//
//  GHCustomTimeSettings.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 8/29/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import "GHCustomSettings.h"

/**
 *  The GHCustomTimeSettings class contains FIT settings values retrieved
 *  from a Garmin device or is used to to set new values on on the device.
 */
@interface GHCustomTimeSettings : GHCustomSettings

/**
 * The number of seconds since the Garmin epoch which is 1989-12-31 00:00:00 UTC.
 */
@property (nonnull, nonatomic) NSNumber *realTimeClockSeconds;

/**
 * The number of seconds until midnight.
 */
@property (nonnull, nonatomic) NSNumber *secondsToMidnight;

/**
 * The time zone offset from UTC.
 */
@property (nonnull, nonatomic) NSNumber *timezoneOffset;


@end
